import logging
from datetime import datetime

from crm.agency_cabinet.common.yt.synchronizers import BaseSynchronizer
from crm.agency_cabinet.documents.server.src.db import models


LOGGER = logging.getLogger('celery.tasks.documents.payments.synchronizers')


class PaymentsSynchronizer(BaseSynchronizer):
    async def process_data(self, rows: list[tuple], *args, **kwargs) -> bool:
        # row: eid, amount, date, invoice_eid
        for row in rows:
            invoice = await self._get_invoice(row[3])

            if invoice:
                date = datetime.strptime(row[2], '%Y-%m-%dT%H:%M:%SZ') if row[2] else None

                await models.Payment.create(
                    eid=row[0],
                    amount=row[1],
                    date=date,
                    currency=invoice.currency,
                    invoice_id=invoice.id
                )
        return True

    async def _get_invoice(self, invoice_eid):
        return await models.Invoice.query.where(models.Invoice.eid == invoice_eid).gino.first()
