import environ
from environs import Env
from gino.dialects.asyncpg import Pyscopg2Pool
from sqlalchemy.engine.url import URL

from crm.agency_cabinet.common.server.rpc.config import RpcServerConfig
from crm.agency_cabinet.common.consts.tvm import TVMIdTest
from crm.agency_cabinet.common.server.common.tvm import Tvm2Config

env = Env()


@environ.config(prefix='TVM2')
class DocumentsTvm2Config(Tvm2Config):
    pass


@environ.config(prefix='')
class DocumentsConfig(RpcServerConfig):
    pass


class Settings:
    db = {
        'dsn': URL(
            drivername='postgresql',
            username=env('PG_LOCAL_USER', 'postgres'),
            password=env('PG_LOCAL_PASSWORD', 'postgres'),
            host=env('PG_LOCAL_HOST', 'localhost'),
            port=env.int('PG_LOCAL_PORT', 5432),
            database=env('PG_LOCAL_DATABASE', 'postgres'),
        ),
        'ssl': env('PG_SSL', 'verify-full'),
        'pool_class': Pyscopg2Pool
    }


db_config = Settings()

gino_metadata_settings = {
    'schema': 'documents',
    'naming_convention': {
        'ix': '%(table_name)__%(column_0_name)s__idx',
        'uq': '%(table_name)s__%(column_0_name)s__uq',
        'ck': '%(table_name)s__%(constraint_name)s__ck',
        'fk': '%(table_name)s_%(referred_table_name)s__%(column_0_name)s__fk',
        'pk': '%(table_name)s__pk'
    }
}

SQS_SETTINGS = {
    'SQS_ACCESS_KEY': env('AWS_ACCESS_KEY_ID', 'agency-cabinet-test'),
    'SQS_SECRET_KEY': env('AWS_SECRET_ACCESS_KEY', 'unused'),
    'SQS_URL': env('SQS_URL', 'sqs.yandex.net:8771'),
    'SQS_OAUTH_TOKEN': env('AWS_SESSION_TOKEN', '')

}
# TODO: сделать, чтобы было без этой фигни (см. патч в chats/понять почему работает в аддаптере?)
# IMPORTANT: DO NOT SPECIFY NEITHER ACCESS_KEY NOR SECRET_KEY HERE
# They should be passed with session token in env vars, otherwise celery will
# take them from params, ignoring session token in env var
SQS_ENDPOINT = f'sqs://{SQS_SETTINGS["SQS_URL"]}'

CELERY_SETTINGS = {
    'broker_url': SQS_ENDPOINT if env.bool('USE_SQS', True) else env('BROKER_URL', 'redis://localhost:6379'),
    'result_expires': None,  # despite we don't use result_backend (i.e. DisabledBackend), celery beat generates
    'task_routes': {              # task to clean up dummy backend; remove if/when we use result_backend
        'crm.agency_cabinet.documents.server.src.celery.tasks.*': {
            'queue': 'documents'
        }
    },
    'imports': ['crm.agency_cabinet.common.celery.signals', 'crm.agency_cabinet.documents.server.src.celery.tasks'],
    'beat_schedule': {
    },
    'beat_scheduler': 'crm.agency_cabinet.common.celery.scheduler.LockedPersistentScheduler',
    'broker_transport_options': {
        'is_secure': False,
        'region': 'yandex',
    }
}

# TODO: move to common
SCHEDULER_LOCK_SETTINGS = {
    'proxy': env('SCHEDULER_LOCK_PROXY', 'freud'),
    'prefix': env('SCHEDULER_LOCK_PREFIX', 'tmp'),
    'token': env('YT_TOKEN', None),
    'lock_params': {
        'lock_key': env('SCHEDULER_LOCK_KEY', 'documents-celerybeat-lock'),  # + env?
        'next_try_timeout': 30
    }
}

YT_CONFIG = {
    'TOKEN': env('YT_TOKEN', None)
}

YQL_CONFIG = {
    'TOKEN': env('YQL_TOKEN', None)
}

YADOC_CONFIG = {
    'endpoint_url': env('YADOC_ENDPOINT_URL', None),
    'tvm_id': env.int('YADOC_TVM_ID', TVMIdTest.yadoc.value)
}
