from crm.agency_cabinet.common.db.models import BaseModel, db, NumericType


class Act(BaseModel):
    __tablename__ = 'act'

    id = db.Column(db.BigInteger, primary_key=True)
    invoice_id = db.Column(db.BigInteger, nullable=False)
    eid = db.Column(db.Text, nullable=False, unique=True)
    amount = db.Column(NumericType, nullable=False)
    currency = db.Column(db.Text, nullable=False)
    date = db.Column(db.DateTime(timezone=True), nullable=False)
    yadoc_id = db.Column(db.BigInteger, nullable=True)

    __table_args__ = (
        db.ForeignKeyConstraint(['invoice_id'], ['invoice.id'], ondelete='CASCADE'),
        db.Index('act__eid_idx', 'eid', unique=True),
    )
