from crm.agency_cabinet.common.db.models import BaseModel, db


class Agreement(BaseModel):
    __tablename__ = 'agreement'

    id = db.Column(db.BigInteger, primary_key=True)
    contract_id = db.Column(db.BigInteger)
    name = db.Column(db.Text(collation='C.UTF-8'), nullable=False)
    got_scan = db.Column(db.Boolean, nullable=False)
    got_original = db.Column(db.Boolean, nullable=False)
    date = db.Column(db.DateTime(timezone=True))

    __table_args__ = (
        db.ForeignKeyConstraint(['contract_id'], ['contract.id'], ondelete='CASCADE'),
    )
