from crm.agency_cabinet.common.db.models import BaseModel, db, NumericType


class Contract(BaseModel):
    __tablename__ = 'contract'

    id = db.Column(db.BigInteger, primary_key=True)
    eid = db.Column(db.Text(collation='C.UTF-8'), nullable=False, unique=True)
    inn = db.Column(db.Text, nullable=False)
    agency_id = db.Column(db.BigInteger, nullable=False)
    payment_type = db.Column(db.Text)
    signing_date = db.Column(db.DateTime(timezone=True))
    finish_date = db.Column(db.DateTime(timezone=True), nullable=False)
    credit_limit = db.Column(NumericType)
    services = db.Column(db.ARRAY(db.String))
    status = db.Column(db.Text, nullable=False)

    __table_args__ = (
        db.Index('contract__eid_idx', 'eid', unique=True),
        db.Index('contract__agency_id_idx', 'agency_id', unique=False),
    )
