from crm.agency_cabinet.common.db.models import BaseModel, db, NumericType
from crm.agency_cabinet.documents.server.src.db.models.contract import Contract


class Invoice(BaseModel):
    __tablename__ = 'invoice'

    id = db.Column(db.BigInteger, primary_key=True)
    contract_id = db.Column(db.BigInteger, nullable=False)
    eid = db.Column(db.Text(collation='C.UTF-8'), nullable=False, unique=True)
    amount = db.Column(NumericType, nullable=False)
    currency = db.Column(db.Text, nullable=False)
    status = db.Column(db.Text, nullable=False)
    date = db.Column(db.DateTime(timezone=True), nullable=False)
    payment_date = db.Column(db.DateTime(timezone=True))
    yadoc_id = db.Column(db.BigInteger, nullable=True)

    __table_args__ = (
        db.ForeignKeyConstraint(['contract_id'], ['contract.id'], ondelete='CASCADE'),
        db.Index('invoice__eid_idx', 'eid', unique=True),
    )

    _contract = None

    @property
    def contract(self) -> Contract:
        return self._contract

    @contract.setter
    def contract(self, value: Contract):
        self._contract = value


class Facture(BaseModel):
    __tablename__ = 'factura'

    id = db.Column(db.BigInteger, primary_key=True)
    invoice_id = db.Column(db.BigInteger, nullable=False)
    date = db.Column(db.DateTime(timezone=True), nullable=False)
    amount = db.Column(NumericType, nullable=False)
    amount_with_nds = db.Column(NumericType, nullable=False)
    nds = db.Column(NumericType, nullable=False)
    currency = db.Column(db.Text, nullable=False)
    yadoc_id = db.Column(db.BigInteger, nullable=True)
    act_id = db.Column(db.BigInteger, nullable=False, unique=True)

    __table_args__ = (
        db.ForeignKeyConstraint(['invoice_id'], ['invoice.id'], ondelete='CASCADE'),
        db.ForeignKeyConstraint(['act_id'], ['act.id'], ondelete='CASCADE'),
    )
