from crm.agency_cabinet.common.db.models import BaseModel, db, NumericType


class Payment(BaseModel):
    __tablename__ = 'payment'

    id = db.Column(db.BigInteger, primary_key=True)
    eid = db.Column(db.Text, nullable=False)
    invoice_id = db.Column(db.BigInteger, nullable=False)
    amount = db.Column(NumericType, nullable=False)
    currency = db.Column(db.Text, nullable=False)
    date = db.Column(db.DateTime(timezone=True), nullable=False)

    __table_args__ = (
        db.ForeignKeyConstraint(['invoice_id'], ['invoice.id'], ondelete='CASCADE'),
    )
