import itertools
from crm.agency_cabinet.documents.server.src.exceptions import FileNotFound


def extract_contract_data(contracts, contract_id):
    return next((
        contract_data for contract_data in contracts
        if contract_id is None or contract_data.get('contract_id') == contract_id
    ), {})


async def update_yadoc_id_and_get_yadoc_url(doc_info, yadoc_client, model, model_id, contract_id=None):
    documents_data = doc_info.get('documents', []) if doc_info else []
    contracts_data = extract_contract_data(doc_info.get('contracts', []), contract_id)
    contract_documents_data = contracts_data.get('documents') if contracts_data else []

    merged_documents_data = itertools.chain(documents_data, contract_documents_data)
    doc_ids = (doc.get('doc_id') for doc in merged_documents_data if doc.get('doc_id') is not None)

    yadoc_id = next(doc_ids, None)
    if yadoc_id is not None:
        url = await yadoc_client.get_doc_url(yadoc_id)
        await model.update.values(
            yadoc_id=yadoc_id
        ).where(model.id == model_id).gino.status(read_only=False, reuse=False)
    else:
        raise FileNotFound()
    return url
