PY3_LIBRARY()

OWNER(
    g:agency_cabinet_back
)

PEERDIR(
    contrib/python/alembic
    contrib/python/ipython

    crm/agency_cabinet/common/celery
    crm/agency_cabinet/common/config
    crm/agency_cabinet/common/db
    crm/agency_cabinet/common/monitoring
    crm/agency_cabinet/common/service_discovery
    crm/agency_cabinet/common/server/rpc
    crm/agency_cabinet/common/yql
    crm/agency_cabinet/common/yt
    crm/agency_cabinet/common/yadoc

    crm/agency_cabinet/documents/common
    crm/agency_cabinet/documents/proto
)

PY_SRCS(
    src/celery/__init__.py
    src/celery/base.py
    src/celery/tasks/__init__.py

    src/celery/tasks/load_acts/loader.py
    src/celery/tasks/load_acts/synchronizer.py
    src/celery/tasks/load_contracts/loader.py
    src/celery/tasks/load_contracts/synchronizer.py
    src/celery/tasks/load_invoices/loader.py
    src/celery/tasks/load_invoices/synchronizer.py
    src/celery/tasks/load_factures/loader.py
    src/celery/tasks/load_factures/synchronizer.py
    src/celery/tasks/load_payments/loader.py
    src/celery/tasks/load_payments/synchronizer.py

    src/db/models/__init__.py
    src/db/models/act.py
    src/db/models/agreement.py
    src/db/models/contract.py
    src/db/models/invoice.py
    src/db/models/payment.py
    src/db/__init__.py
    src/db/engine.py
    src/db/queries.py

    src/__init__.py
    src/config.py
    src/exceptions.py
    src/handler.py

    src/procedures/__init__.py
    src/procedures/acts.py
    src/procedures/agreements.py
    src/procedures/contracts.py
    src/procedures/invoices.py
    src/procedures/payments.py
)

END()

RECURSE_FOR_TESTS(tests)

RECURSE(
    bin
    migrations
)
