import crm.agency_cabinet.common.monitoring.clusters as clusters

from crm.agency_cabinet.common.monitoring.sensors import get_service_uptime, get_service_http_response_rate, get_service_response_time
from crm.agency_cabinet.gateway.monitoring.registry.service import gateway


testing_gateway_uptime = get_service_uptime(clusters.testing, gateway)
prestable_gateway_uptime = get_service_uptime(clusters.prestable, gateway)
prod_gateway_uptime = get_service_uptime(clusters.prod, gateway)

(
    testing_gateway_response_rate_ok,
    testing_gateway_response_rate_client_error,
    testing_gateway_response_rate_error
) = get_service_http_response_rate(clusters.testing, gateway)

(
    prestable_gateway_response_rate_ok,
    prestable_gateway_response_rate_client_error,
    prestable_gateway_response_rate_error
) = get_service_http_response_rate(clusters.prestable, gateway)

(
    prod_gateway_response_rate_ok,
    prod_gateway_response_rate_client_error,
    prod_gateway_response_rate_error
) = get_service_http_response_rate(clusters.prod, gateway)


GATEWAY_UPTIME_METRIC = {
    clusters.testing: testing_gateway_uptime,
    clusters.prestable: prestable_gateway_uptime,
    clusters.prod: prestable_gateway_uptime
}


testing_gateway_response_time = get_service_response_time(clusters.testing, gateway)
prestable_gateway_response_time = get_service_response_time(clusters.prestable, gateway)
prod_gateway_response_time = get_service_response_time(clusters.prod, gateway)


register = [testing_gateway_uptime,
            testing_gateway_response_time,
            prestable_gateway_uptime,
            prestable_gateway_response_time,
            prod_gateway_uptime,
            prod_gateway_response_time]
