from aiohttp import web
from aiohttp_apispec import docs, querystring_schema
from crm.agency_cabinet.common.service_discovery import ServiceDiscovery
from crm.agency_cabinet.gateway.server.src.handlers.common import (
    development_headers_docs,
    json_response,
)
from crm.agency_cabinet.gateway.server.src.handlers.schemas import payments_schemas
from crm.agency_cabinet.gateway.server.src.procedures import payments_procedures

from marshmallow import EXCLUDE


class PaymentsCollection:
    def __init__(self, sd: ServiceDiscovery):
        self._list_payments = payments_procedures.ListPayments(sd)

    @docs(
        tags=['documents'],
        summary='Список платежей агентства',
        responses={
            200: {"schema": payments_schemas.PaymentsListSchema()},
            401: {
                'description': 'Unauthorized'
            },
            403: {
                'description': 'Forbidden'  # TODO: у ошибок есть схема, поэтому надо добавить в спеку
            },
            422: {
                'description': 'Unprocessable'
            }
        }
    )
    @querystring_schema(payments_schemas.ListPaymentsParamsSchema(unknown=EXCLUDE))
    @development_headers_docs
    async def list_payments(self, request: web.Request) -> web.Response:
        agency_id = int(request.match_info['agency_id'])
        payments = await self._list_payments(
            yandex_uid=request['yandex_uid'],
            agency_id=agency_id,
            **request['querystring']
        )

        data = {
            'items': payments
        }
        return json_response(data=payments_schemas.PaymentsListSchema().dump(data))
