from aiohttp import web
from aiohttp_apispec import docs, querystring_schema
from marshmallow import EXCLUDE

from crm.agency_cabinet.common.service_discovery import ServiceDiscovery
from crm.agency_cabinet.gateway.server.src.handlers.common import development_headers_docs, json_response
from crm.agency_cabinet.gateway.server.src.handlers.schemas import ord_campaigns_schemas
from crm.agency_cabinet.gateway.server.src.procedures import ord_campaigns_procedures


class OrdCampaignsCollection:
    def __init__(self, sd: ServiceDiscovery):
        self._list_campaigns = ord_campaigns_procedures.ListCampaigns(sd)

    @docs(
        tags=['ord'],
        summary='Получение списка кампаний',
        responses={
            200: {
                'schema': ord_campaigns_schemas.OrdCampaignListSchema(),
                'description': 'Ok'
            },
            401: {
                'description': 'Unauthorized'
            },
            403: {
                'description': 'Forbidden'
            }
        }
    )
    @querystring_schema(ord_campaigns_schemas.RequestListCampaignsSchema(unknown=EXCLUDE))
    @development_headers_docs
    async def list_campaigns(self, request: web.Request) -> web.Response:
        agency_id = int(request.match_info['agency_id'])
        report_id = int(request.match_info['report_id'])
        client_id = int(request.match_info['client_id'])
        campaigns = await self._list_campaigns(
            agency_id=agency_id,
            report_id=report_id,
            client_id=client_id,
            yandex_uid=request['yandex_uid'],
            **request['querystring']
        )
        return json_response(data=ord_campaigns_schemas.OrdCampaignListSchema().dump(campaigns))
