from aiohttp import web
from aiohttp_apispec import docs, querystring_schema
from marshmallow import EXCLUDE

from crm.agency_cabinet.common.service_discovery import ServiceDiscovery
from crm.agency_cabinet.gateway.server.src.handlers.common import development_headers_docs, json_response
from crm.agency_cabinet.gateway.server.src.handlers.schemas import ord_contracts_schemas
from crm.agency_cabinet.gateway.server.src.procedures import ord_contracts_procedures


class OrdContractsCollection:
    def __init__(self, sd: ServiceDiscovery):
        self._list_contracts = ord_contracts_procedures.ListContracts(sd)

    @docs(
        tags=['ord'],
        summary='Получение списка контрактов',
        responses={
            200: {
                'schema': ord_contracts_schemas.OrdContractsListSchema(),
                'description': 'Ok'
            },
            401: {
                'description': 'Unauthorized'
            },
            403: {
                'description': 'Forbidden'
            }
        }
    )
    @querystring_schema(ord_contracts_schemas.OrdGetContractsSchema(unknown=EXCLUDE))
    @development_headers_docs
    async def list_contracts(self, request: web.Request) -> web.Response:
        agency_id = int(request.match_info['agency_id'])
        client_contracts_list = await self._list_contracts(
            agency_id=agency_id,
            yandex_uid=request['yandex_uid'],
            **request['querystring']
        )
        return json_response(data=ord_contracts_schemas.OrdContractsListSchema().dump(client_contracts_list))
