from aiohttp import web
from aiohttp_apispec import docs, querystring_schema
from marshmallow import EXCLUDE

from crm.agency_cabinet.common.service_discovery import ServiceDiscovery
from crm.agency_cabinet.gateway.server.src.handlers.common import development_headers_docs, json_response
from crm.agency_cabinet.gateway.server.src.handlers.schemas import ord_invites_schemas
from crm.agency_cabinet.gateway.server.src.procedures import ord_invites_procedures


class OrdInvitesCollection:
    def __init__(self, sd: ServiceDiscovery):
        self._get_invites = ord_invites_procedures.GetInvites(sd)

    @docs(
        tags=['ord'],
        summary='Список приглашений',
        responses={
            200: {
                'schema': ord_invites_schemas.OrdInviteListSchema(),
                'description': 'Ok'
            },
            401: {
                'description': 'Unauthorized'
            },
            403: {
                'description': 'Forbidden'
            }
        }
    )
    @querystring_schema(ord_invites_schemas.OrdRequestGetInvitesSchema(unknown=EXCLUDE))
    @development_headers_docs
    async def get_invites(self, request: web.Request) -> web.Response:
        agency_id = int(request.match_info['agency_id'])
        data = await self._get_invites(
            yandex_uid=request['yandex_uid'],
            agency_id=agency_id,
            **request['querystring']
        )
        return json_response(data=ord_invites_schemas.OrdInviteListSchema().dump(data))
