from aiohttp import web
from aiohttp_apispec import docs, querystring_schema
from marshmallow import EXCLUDE

from crm.agency_cabinet.common.service_discovery import ServiceDiscovery
from crm.agency_cabinet.gateway.server.src.handlers.common import development_headers_docs, json_response
from crm.agency_cabinet.gateway.server.src.handlers.schemas import ord_organizations_schemas
from crm.agency_cabinet.gateway.server.src.procedures import ord_organizations_procedures


class OrdOrganizationsCollection:
    def __init__(self, sd: ServiceDiscovery):
        self._list_organizations = ord_organizations_procedures.ListOrganizations(sd)

    @docs(
        tags=['ord'],
        summary='Получение списка организаций',
        responses={
            200: {
                'schema': ord_organizations_schemas.OrganizationsListSchema(),
                'description': 'Ok'
            },
            401: {
                'description': 'Unauthorized'
            },
            403: {
                'description': 'Forbidden'
            }
        }
    )
    @querystring_schema(ord_organizations_schemas.RequestListOrganizationsSchema(unknown=EXCLUDE))
    @development_headers_docs
    async def list_organizations(self, request: web.Request) -> web.Response:
        partner_id = int(request.match_info['agency_id'])
        organizations = await self._list_organizations(
            partner_id=partner_id,
            yandex_uid=request['yandex_uid'],
            **request['querystring']
        )
        result = ord_organizations_schemas.OrganizationsListSchema().dump(organizations)
        return json_response(data=result)
