from aiohttp import web
from aiohttp_apispec import docs

from crm.agency_cabinet.common.service_discovery import ServiceDiscovery
from crm.agency_cabinet.gateway.server.src.handlers.common import development_headers_docs, json_response
from crm.agency_cabinet.gateway.server.src.handlers.schemas import documents_schemas
from crm.agency_cabinet.gateway.server.src.procedures import documents_procedures


class DocumentsCollection:
    def __init__(self, sd: ServiceDiscovery):
        self._get_document_url = documents_procedures.GetDocumentUrl(sd)

    @docs(
        tags=['documents_rewards'],
        summary='Ссылка для скачивания документа',
        responses={
            200: {
                'schema': documents_schemas.DocumentUrlSchema(),
                'description': 'Ok'
            },
            401: {
                'description': 'Unauthorized'
            },
            403: {
                'description': 'Forbidden'  # TODO: у ошибок есть схема, поэтому надо добавить в спеку
            },
            404: {
                'description': 'Not found',
            },
            422: {
                'description': 'Unprocessable'
            }
        }
    )
    @development_headers_docs
    async def document_url(self, request: web.Request) -> web.Response:
        document_id = int(request.match_info['document_id'])
        agency_id = int(request.match_info['agency_id'])
        url = await self._get_document_url(request['yandex_uid'], agency_id, document_id)
        return json_response(
            data=documents_schemas.DocumentUrlSchema().dump({'url': url}),
            headers={'Cache-Control': 'no-cache'}
        )
