from marshmallow import Schema, fields, validate

from crm.agency_cabinet.common.consts.contract import convert_contract_type


__all__ = [
    'AgenciesListSchema',
    'AgencyInfoSchema',
    'ContractsListSchema',
    'ClientInfoSchema',
    'ClientsListSchema',
    'GetClientsInfoSchema'
]


class ContractInfoSchema(Schema):
    contract_id = fields.Integer(required=True)
    eid = fields.String(required=True)
    finish_date = fields.DateTime(required=True)
    services = fields.List(fields.String)
    inn = fields.String(required=True)
    payment_type = fields.String(required=True)
    type = fields.Function(lambda obj: convert_contract_type(obj.type))
    is_crisis = fields.Boolean(required=True)


class ContractMinimalInfoSchema(ContractInfoSchema):
    class Meta:
        fields = ('contract_id', 'eid', 'inn', 'payment_type', 'finish_date', 'type', 'is_crisis')


class ContractsListSchema(Schema):
    contracts = fields.List(fields.Nested(ContractInfoSchema))


class AgencyInfoSchema(Schema):
    agency_id = fields.Integer(required=True)
    name = fields.String(required=True)
    phone = fields.String()
    email = fields.String()
    site = fields.String()
    actual_address = fields.String()
    legal_address = fields.String()
    contracts = fields.List(fields.Nested(ContractMinimalInfoSchema))


class AgencyMinimalInfoSchema(AgencyInfoSchema):
    class Meta:
        fields = ('agency_id', 'name')


class AgenciesListSchema(Schema):
    agencies = fields.List(fields.Nested(AgencyMinimalInfoSchema))


class ClientInfoSchema(Schema):
    id = fields.Integer(data_key='client_id')
    name = fields.String()
    login = fields.String()


class ClientsListSchema(Schema):
    clients = fields.List(fields.Nested(ClientInfoSchema))


class GetClientsInfoSchema(Schema):
    limit = fields.Integer(load_default=100)
    offset = fields.Integer()
    search_query = fields.String(validate=validate.Length(min=1))
