from marshmallow import Schema, fields, validate, ValidationError
from crm.agency_cabinet.common.server.common import structs


class EmptySchema(Schema):
    pass


class DevelopmentHeadersSchema(Schema):
    no_check_service_ticket = fields.String(data_key='No-Check-Service-Ticket',
                                            metadata={
                                                'description': 'Можно передать любое значение. Работает только в developer_mode.'})
    no_check_user_ticket = fields.String(data_key='No-Check-User-Ticket',
                                         metadata={'description': 'uid пользователя. Работает только в developer_mode.'})


class DeleteStatusSchema(Schema):
    status = fields.Constant('ok')


class LimitOffsetSchema(Schema):
    limit = fields.Integer(validate=validate.Range(min=0))
    offset = fields.Integer(validate=validate.Range(min=0))


class SearchQuerySchema(Schema):
    search_query = fields.String(validate=validate.Length(min=1))


# TODO move to common
class SortField(fields.String):
    def __init__(self, column_enum_sort_type, column_sort_type):
        super().__init__()
        self.column_enum_sort_type = column_enum_sort_type
        self.column_sort_type = column_sort_type

    def _deserialize(self, value, attr, data, **kwargs):
        try:
            res = []
            if not value:
                return res
            for s in value.split(','):
                if s.startswith('-'):
                    res.append(self.column_sort_type(
                        structs.SortTypes.desc,
                        self.column_enum_sort_type(s[1:])
                    ))
                else:
                    res.append(self.column_sort_type(
                        structs.SortTypes.asc,
                        self.column_enum_sort_type(s)
                    ))
            return res
        except Exception:
            raise ValidationError('wrong sort format')  # TODO better error log


class SizedSchema(Schema):
    size = fields.Integer()


class SuccessStatusSchema(Schema):
    status = fields.Constant('ok')
