from marshmallow import fields, Schema
from marshmallow_enum import EnumField

from crm.agency_cabinet.common.consts import Services


class DashboardRewardSchema(Schema):
    predict = fields.Boolean()
    reward = fields.Float()
    reward_percent = fields.Float()
    period_from = fields.DateTime()


class DashboardRewardsMapSchema(Schema):
    month = fields.List(fields.Nested(DashboardRewardSchema))
    quarter = fields.List(fields.Nested(DashboardRewardSchema))
    semiyear = fields.List(fields.Nested(DashboardRewardSchema))


class DashboardItemSchema(Schema):
    service = EnumField(Services)
    contract_id = fields.Integer()
    active = fields.Boolean()
    rewards = fields.Nested(DashboardRewardsMapSchema)
    updated_at = fields.DateTime()


class DashboardSchema(Schema):
    dashboard = fields.List(fields.Nested(DashboardItemSchema))


class GetDashboardSchema(Schema):
    contract_id = fields.Integer(
        description='Если указано, то возвращаются только те отчеты, что привязаны к заданному контракту'
    )
    service = EnumField(
        Services,
        description='Если указано, то возвращаются только те отчеты, чей сервис совпадает с заданным'
    )
    year = fields.Integer(load_default=2021)  # TODO remove default value
