from marshmallow import (
    Schema,
    fields,
    validate,
    validates_schema,
    ValidationError,
)


__all__ = [
    'ActInfoSchema',
]


class ActInfoSchema(Schema):
    act_id = fields.Integer(required=True)
    invoice_id = fields.Integer(required=True)
    contract_id = fields.Integer(required=True)
    date = fields.AwareDateTime(format='iso', required=True)
    amount = fields.Float(required=True)
    currency = fields.String(required=True)
    eid = fields.String(required=True)
    contract_eid = fields.String(required=True)
    invoice_eid = fields.String(required=True)


class ListActsParamsSchema(Schema):
    contract_id = fields.Integer()
    invoice_id = fields.Integer()
    limit = fields.Integer()
    offset = fields.Integer()
    date_from = fields.AwareDateTime(format='iso')
    date_to = fields.AwareDateTime(format='iso')
    search_query = fields.String(validate=validate.Length(min=1))

    @validates_schema
    def _check_params(self, data, *args, **kwargs):
        if data.get('date_from') and data.get('date_to'):
            if data['date_from'] > data['date_to']:
                raise ValidationError(
                    'Date to must be grater or equal date from.'
                )


class ActsListSchema(Schema):
    items = fields.List(fields.Nested(ActInfoSchema))
