from marshmallow import (
    Schema,
    fields,
    validate,
    validates_schema,
    ValidationError,
)


class AgreementInfoSchema(Schema):
    agreement_id = fields.Integer(required=True)
    name = fields.String(required=True)
    got_scan = fields.Boolean(required=True)
    got_original = fields.Boolean(required=True)
    date = fields.AwareDateTime(format="iso")


class ListAgreementsParamsSchema(Schema):
    contract_id = fields.Integer(required=True)
    limit = fields.Integer()
    offset = fields.Integer()
    date_from = fields.AwareDateTime(format='iso')
    date_to = fields.AwareDateTime(format='iso')
    search_query = fields.String(validate=validate.Length(min=1))

    @validates_schema
    def _check_params(self, data, *args, **kwargs):
        if data.get('date_from') and data.get('date_to'):
            if data['date_from'] > data['date_to']:
                raise ValidationError(
                    'Date to must be grater or equal date from.'
                )


class AgreementsListSchema(Schema):
    items = fields.List(fields.Nested(AgreementInfoSchema))
