from marshmallow import (
    Schema,
    fields,
)
from marshmallow_enum import EnumField

from crm.agency_cabinet.documents.common.structs import ContractStatus
from crm.agency_cabinet.common.consts import PaymentType, Services

__all__ = [
    'ContractInfoSchema',
    'ContractMinimalInfoSchema',
]


class ContractInfoSchema(Schema):
    contract_id = fields.Integer(required=True)
    eid = fields.String(required=True)
    inn = fields.String(required=True)
    status = EnumField(ContractStatus, required=True)
    payment_type = EnumField(PaymentType)
    services = fields.List(EnumField(Services), required=True)
    signing_date = fields.AwareDateTime(format="iso")
    finish_date = fields.AwareDateTime(format="iso", required=True)
    credit_limit = fields.Float()


class ContractMinimalInfoSchema(ContractInfoSchema):
    class Meta:
        fields = ('contract_id', 'eid', 'status', 'payment_type', 'services', 'signing_date', 'finish_date')


class ContractsListSchema(Schema):
    items = fields.List(fields.Nested(ContractMinimalInfoSchema))
