from marshmallow import Schema, fields, validate
from marshmallow_enum import EnumField

from crm.agency_cabinet.documents.common.structs import InvoiceStatus

__all__ = [
    'InvoiceInfoSchema',
]


class GetListInvoicesSchema(Schema):
    contract_id = fields.Integer()
    date_from = fields.AwareDateTime(format='iso')
    date_to = fields.AwareDateTime(format='iso')
    status = EnumField(InvoiceStatus)
    limit = fields.Integer()
    offset = fields.Integer()
    search_query = fields.String(validate=validate.Length(min=1))


class FactureInfoSchema(Schema):
    facture_id = fields.Integer(required=True)
    factura_id = fields.Method('temp_make_facutra_id')  # TODO: remove
    amount = fields.Float(required=True)
    amount_with_nds = fields.Float(required=True)
    nds = fields.Float(required=True)
    currency = fields.String(required=True)
    date = fields.AwareDateTime(format="iso", required=True)

    def temp_make_facutra_id(self, obj):
        return obj.facture_id if hasattr(obj, 'facture_id') else None


class BaseInvoiceInfoSchema(Schema):
    invoice_id = fields.Integer(required=True)
    eid = fields.String(required=True)
    contract_id = fields.Integer()
    contract_eid = fields.String(required=True)
    amount = fields.Float(required=True)
    currency = fields.String(required=True)
    date = fields.AwareDateTime(format="iso", required=True)
    payment_date = fields.AwareDateTime(format="iso")
    status = EnumField(InvoiceStatus, required=True)


class InvoiceInfoSchema(BaseInvoiceInfoSchema):
    has_facture = fields.Bool(required=True)
    has_factura = fields.Method('temp_make_factura')  # TODO: remove

    def temp_make_factura(self, obj):
        return getattr(obj, 'has_facture', None)


class InvoicesListSchema(Schema):
    items = fields.List(fields.Nested(InvoiceInfoSchema))


class DetailedInvoiceInfoSchema(BaseInvoiceInfoSchema):
    facture = fields.Nested(FactureInfoSchema)
