from marshmallow import fields, Schema

from crm.agency_cabinet.gateway.server.src.handlers.schemas.common import SizedSchema, LimitOffsetSchema, \
    SearchQuerySchema

__all__ = [
    'OrdRequestAddOrEditActSchema',
    'OrdActSchema',
    'RequestOrdGetActsSchema',
    'OrdActListSchema',
]


class OrdActSchema(Schema):
    act_id = fields.Integer()
    act_eid = fields.String()
    amount = fields.String()
    is_vat = fields.Boolean()


class OrdRequestAddOrEditActSchema(OrdActSchema):
    class Meta:
        exclude = ['act_id']


class RequestOrdGetActsSchema(LimitOffsetSchema, SearchQuerySchema):
    pass


class OrdActListSchema(SizedSchema):
    items = fields.List(fields.Nested(OrdActSchema), attribute='acts')
