from marshmallow import fields, Schema

from crm.agency_cabinet.gateway.server.src.handlers.schemas.common import LimitOffsetSchema, SearchQuerySchema, \
    SizedSchema

__all__ = [
    'OrdCampaignSchema',
    'OrdCampaignListSchema',
    'RequestListCampaignsSchema'
]


class OrdCampaignSchema(Schema):
    id = fields.Integer()
    campaign_eid = fields.String()
    name = fields.String()


class OrdCampaignListSchema(SizedSchema):
    items = fields.List(fields.Nested(OrdCampaignSchema), attribute='campaigns')


class RequestListCampaignsSchema(LimitOffsetSchema, SearchQuerySchema):
    pass
