from marshmallow import fields, Schema

from .acts import OrdActSchema
from .campaigns import OrdCampaignSchema
from .contracts import OrdContractSchema
from .organizations import OrganizationSchema
from crm.agency_cabinet.gateway.server.src.handlers.schemas.common import SizedSchema, LimitOffsetSchema, \
    SearchQuerySchema


__all__ = [
    'OrdClientRowSchema',
    'OrdClientRowsListSchema',
    'RequestOrdClientRowsSchema',
    'OrdEditClientRowSchema',
]


class OrdClientRowSchema(Schema):
    id = fields.Integer()
    suggested_amount = fields.Float()
    campaign = fields.Nested(OrdCampaignSchema)
    ad_distributor_organization = fields.Nested(OrganizationSchema)
    ad_distributor_partner_organization = fields.Nested(OrganizationSchema)
    partner_client_organization = fields.Nested(OrganizationSchema)
    advertiser_contractor_organization = fields.Nested(OrganizationSchema)
    advertiser_organization = fields.Nested(OrganizationSchema)
    ad_distributor_contract = fields.Nested(OrdContractSchema)
    ad_distributor_partner_contract = fields.Nested(OrdContractSchema)
    advertiser_contract = fields.Nested(OrdContractSchema)
    ad_distributor_act = fields.Nested(OrdActSchema)
    ad_distributor_partner_act = fields.Nested(OrdActSchema)


class OrdClientRowsListSchema(SizedSchema):
    items = fields.List(fields.Nested(OrdClientRowSchema), attribute='rows')


class RequestOrdClientRowsSchema(LimitOffsetSchema, SearchQuerySchema):
    pass


class OrdEditClientRowSchema(Schema):
    client_contract_id = fields.Integer()
    client_act_id = fields.Integer()
    ad_distributor_act_id = fields.Integer()
    campaign_eid = fields.String()
    campaign_name = fields.String()
