from marshmallow import fields, Schema

from crm.agency_cabinet.gateway.server.src.handlers.schemas.common import SizedSchema, LimitOffsetSchema, \
    SearchQuerySchema


__all__ = [
    'OrdReportClientSchema',
    'OrdReportClientsListSchema',
    'OrdClientShortInfoSchema',
]


class OrdReportClientSchema(Schema):
    id = fields.Integer()
    client_id = fields.String()
    login = fields.String()
    name = fields.String()
    suggested_amount = fields.Float()
    campaigns_count = fields.Integer()
    has_valid_ad_distributor = fields.Boolean()
    has_valid_ad_distributor_partner = fields.Boolean()
    has_valid_partner_client = fields.Boolean()
    has_valid_advertiser_contractor = fields.Boolean()
    has_valid_advertiser = fields.Boolean()


class OrdReportClientsListSchema(SizedSchema):
    items = fields.List(fields.Nested(OrdReportClientSchema))


class GetOrdClientsSchema(LimitOffsetSchema, SearchQuerySchema):
    is_valid = fields.Boolean()


class OrdClientShortInfoSchema(Schema):
    id = fields.Integer(required=True)
    client_id = fields.String(required=True)
    login = fields.String()
    name = fields.String()


class OrdReportCreateClientSchema(Schema):
    client_id = fields.String(required=True)
    login = fields.String()
    name = fields.String()
