from marshmallow import fields, Schema
from marshmallow_enum import EnumField
from crm.agency_cabinet.gateway.server.src.handlers.schemas.common import SizedSchema, LimitOffsetSchema, \
    SearchQuerySchema
from crm.agency_cabinet.ord.common.consts import ContractType, ContractSubjectType, ContractActionType
from .organizations import OrganizationSchema


class OrdContractSchema(Schema):
    id = fields.Integer()
    contract_eid = fields.String()
    is_reg_report = fields.Bool()
    type = EnumField(ContractType)
    action_type = EnumField(ContractActionType)
    subject_type = EnumField(ContractSubjectType)
    date = fields.Date()
    amount = fields.Float()
    is_vat = fields.Bool()

    client_organization = fields.Nested(OrganizationSchema)
    contractor_organization = fields.Nested(OrganizationSchema)


class OrdGetContractsSchema(LimitOffsetSchema, SearchQuerySchema):
    pass


class OrdContractsListSchema(SizedSchema):
    items = fields.List(fields.Nested(OrdContractSchema), attribute='contracts')
