from marshmallow import fields, Schema

from crm.agency_cabinet.gateway.server.src.handlers.schemas.common import SizedSchema, LimitOffsetSchema

__all__ = [
    'OrdInviteSchema',
    'OrdInviteListSchema',
    'OrdRequestGetInvitesSchema',
    'OrdRequestCreateInviteSchema',
    'OrdRequestRevokeInviteSchema'
]


class OrdInviteSchema(Schema):
    invite_id = fields.Integer()
    email = fields.String()
    status = fields.String()
    created_at = fields.Date()


class OrdInviteListSchema(SizedSchema):
    items = fields.List(fields.Nested(OrdInviteSchema), attribute='invites')


class OrdRequestGetInvitesSchema(LimitOffsetSchema):
    pass


class OrdRequestCreateInviteSchema(Schema):
    email = fields.String()


class OrdRequestRevokeInviteSchema(Schema):
    pass
