from marshmallow import fields, Schema

from crm.agency_cabinet.gateway.server.src.handlers.schemas.common import LimitOffsetSchema, SearchQuerySchema, \
    SizedSchema

__all__ = [
    'OrganizationSchema',
    'OrganizationsListSchema',
    'RequestListOrganizationsSchema',
]


class OrganizationSchema(Schema):
    organization_id = fields.Integer(attribute='id')
    type = fields.String()
    name = fields.String()
    inn = fields.String()
    is_rr = fields.Boolean()
    is_ors = fields.Boolean()
    mobile_phone = fields.String()
    epay_number = fields.String()
    reg_number = fields.String()
    alter_inn = fields.String()
    oksm_number = fields.String()
    rs_url = fields.String()


class OrganizationsListSchema(SizedSchema):
    items = fields.List(fields.Nested(OrganizationSchema), attribute='organizations')


class RequestListOrganizationsSchema(LimitOffsetSchema, SearchQuerySchema):
    pass
