from marshmallow import fields, Schema, validate

from crm.agency_cabinet.common.server.common.structs import TaskStatuses
from crm.agency_cabinet.gateway.server.src.handlers.schemas.common import LimitOffsetSchema, SortField, SizedSchema, \
    SearchQuerySchema

from crm.agency_cabinet.ord.common import structs, consts


__all__ = [
    'RequestOrdReportsInfoSchema',
    'OrdReportsListSchema',
    'OrdReportSchema',
]


class RequestOrdReportsInfoSchema(LimitOffsetSchema, SearchQuerySchema):
    status = fields.String(validate=validate.OneOf({e.value for e in consts.ReportStatuses}))
    period_from = fields.Date()
    period_to = fields.Date()
    sort = SortField(structs.ReportColumns, structs.ReportSort)


class ReportSettingsSchema(Schema):
    name = fields.String(required=True)
    display_name = fields.String(required=True)
    allow_create_ad_distributor_acts = fields.Boolean(required=True)
    allow_create_clients = fields.Boolean(required=True)
    allow_create_campaigns = fields.Boolean(required=True)
    allow_edit_report = fields.Boolean(required=True)


class OrdReportSchema(Schema):
    report_id = fields.Integer(required=True)
    status = fields.String(required=True)
    sending_date = fields.Date()
    period_from = fields.Date(required=True)
    reporter_type = fields.String(required=True)
    settings = fields.Nested(ReportSettingsSchema)
    clients_count = fields.Integer()
    campaigns_count = fields.Integer()


class OrdReportsListSchema(SizedSchema):
    items = fields.List(fields.Nested(OrdReportSchema))


class OrdReportExportSchema(Schema):
    report_export_id = fields.Integer()
    status = fields.String(validate=validate.OneOf({e.value for e in TaskStatuses}))


class OrdReportUrlSchema(Schema):
    url = fields.URL()


class ReportImportDataSchema(Schema):
    id = fields.Integer(attribute='task_id')
    status = fields.String()


class ReportLockStatusSchema(Schema):
    lock = fields.Boolean()


class OrdReportCreateSchema(Schema):
    period_from = fields.Date(required=True)
    reporter_type = fields.String(validate=validate.OneOf({e.value for e in consts.ReporterType}))
