from marshmallow import Schema, fields
from marshmallow_enum import EnumField

from crm.agency_cabinet.common.consts.contract import convert_contract_type
from crm.agency_cabinet.common.consts.calculator import CalculatorServiceType
from crm.agency_cabinet.rewards.common.schemas.calculator import (
    CalculatorMetaSchema, CalculatorDataSchema
)

__all__ = [
    'CalculatorRequestSchema',
    'CalculatorMetaSchema',
    'CalculatorDataSchema',
    'CalculatorsDescriptionsSchema',
    'AvailableCalculatorsRequestSchema'
]


class CalculatorRequestSchema(Schema):
    service = EnumField(CalculatorServiceType, required=True)
    contract_id = fields.Int(required=True)
    version = fields.String(required=False)  # TODO: required?


class AvailableCalculatorsRequestSchema(Schema):
    contract_id = fields.Int()


class CalculatorDescriptionSchema(Schema):
    contract_id = fields.Integer()
    service = EnumField(CalculatorServiceType)
    version = fields.String()
    contract_type = fields.Function(lambda obj: convert_contract_type(obj.contract_type), description='Цифра кодирующая тип контракта')


class CalculatorsDescriptionsSchema(Schema):
    items = fields.List(fields.Nested(CalculatorDescriptionSchema()), attribute='calculators_descriptions')
