from marshmallow import fields, Schema, validate

from crm.agency_cabinet.common.consts import Currencies, PaymentsStatuses, RewardsTypes, Services

__all__ = [
    'RewardsMinimalInfoSchema',
    'GetRewardsMinimalInfoSchema',
    'DetailedRewardInfoSchema',
]


# TODO: try marshmallow-dataclass


class RewardsMinimalInfoSchema(Schema):
    id = fields.Integer(required=True)
    contract_id = fields.Integer(required=True)
    type = fields.String(
        required=True,
        validate=validate.OneOf([reward.value for reward in RewardsTypes])
    )
    services = fields.List(
        fields.String(
            validate=validate.OneOf([service.value for service in Services])
        ),
        required=True
    )
    got_scan = fields.Boolean()
    got_original = fields.Boolean()
    is_accrued = fields.Boolean()
    is_paid = fields.Boolean()
    payment_date = fields.DateTime()
    payment = fields.Float()
    period_from = fields.DateTime()


class RewardsListSchema(Schema):
    rewards = fields.List(fields.Nested(RewardsMinimalInfoSchema))


class DetailedServiceInfoSchema(Schema):
    service = fields.String(
        validate=validate.OneOf([service.value for service in Services])
    )

    revenue = fields.Float()
    currency = fields.String(
        validate=validate.OneOf([currency.value for currency in Currencies])
    )
    reward_percent = fields.Float()
    accrual = fields.Float()

    error_message = fields.String()


class DocumentInfoSchema(Schema):
    id = fields.Integer(required=True)
    name = fields.String(required=True)
    got_scan = fields.Boolean()
    got_original = fields.Boolean()
    sending_date = fields.DateTime()


class DetailedRewardInfoSchema(Schema):
    id = fields.Integer()
    contract_id = fields.Integer()

    type = fields.String(
        validate=validate.OneOf([reward.value for reward in RewardsTypes])
    )

    services = fields.List(fields.Nested(DetailedServiceInfoSchema))
    documents = fields.List(fields.Nested(DocumentInfoSchema))

    status = fields.String(
        validate=validate.OneOf([payment.value for payment in PaymentsStatuses])
    )

    accrual = fields.Float()
    payment = fields.Float()

    accrual_date = fields.DateTime()
    payment_date = fields.DateTime()

    period_from = fields.DateTime()
    predict = fields.Boolean()


class GetRewardsMinimalInfoSchema(Schema):
    contract_id = fields.Integer(
        description="Если указано, то возвращаются только те премии, что привязаны к заданному контракту")
    date_from = fields.Date(
        description="Если указано, то возвращаются только те премии, чей расчетный период начался после заданной даты")
    date_to = fields.Date(
        description="Если указано, то возвращаются только те премии, чей расчетный период начался раньше заданной даты")
    type = fields.String(
        validate=validate.OneOf({e.value for e in RewardsTypes}),
        description="Если указано, то возвращаются только те премии, чей тип совпадает с заданным")
    is_paid = fields.Boolean(description="Если указано, то возвращаются только оплаченные/неоплаченные премии")
