from marshmallow import fields, Schema, validate
from marshmallow_enum import EnumField

from crm.agency_cabinet.grants.common.consts.partner import PartnerType


class PermissionSchema(Schema):
    name = fields.String(dump_default='')


class RoleSchema(Schema):
    name = fields.String()
    display_name = fields.String()
    role_id = fields.Integer()
    permissions = fields.List(fields.Pluck(PermissionSchema, 'name'))


class RoleListSchema(Schema):
    roles = fields.List(fields.Nested(RoleSchema))


class InputRoleSchemaFlat(Schema):
    role_id = fields.Integer()
    permissions = fields.List(fields.String, validate=(validate.Length(min=1),))


class InputRoleSchema(Schema):
    role_id = fields.Integer()
    permissions = fields.List(fields.Pluck(PermissionSchema, 'name'), validate=(validate.Length(min=1),))


class UserSchema(Schema):
    user_id = fields.Integer()
    current = fields.Boolean(default=False)
    name = fields.String()
    email = fields.String()
    login = fields.String()
    avatar_id = fields.String()
    roles = fields.List(fields.Nested(RoleSchema))


class UsersListSchema(Schema):
    users = fields.List(fields.Nested(UserSchema))


class GetUsersInfoSchema(Schema):
    search_query = fields.String(validate=validate.Length(min=1))


class GetSuggestedUsersInfoSchema(Schema):
    search_query = fields.String(validate=validate.Length(min=1))


class EditPermissionsStatusSchema(Schema):
    status = fields.Constant('ok')


class SuggestUserSchema(Schema):
    user_id = fields.Integer()
    name = fields.String()
    email = fields.String()
    login = fields.String()
    avatar_id = fields.String()


class SuggestUsersListSchema(Schema):
    users = fields.List(fields.Nested(SuggestUserSchema))


class PermissionInfoSchema(Schema):
    name = fields.String()
    editable = fields.Boolean()


class RoleInfoSchema(Schema):
    role_id = fields.Integer()
    name = fields.String()
    display_name = fields.String()
    permissions = fields.List(fields.Nested(PermissionInfoSchema))


class RoleInfoListSchema(Schema):
    roles = fields.List(fields.Nested(RoleInfoSchema))


class PartnerSchema(Schema):
    partner_id = fields.Integer()
    external_id = fields.String()
    type = EnumField(PartnerType)
    name = fields.String()


class PartnersListSchema(Schema):
    partners = fields.List(fields.Nested(PartnerSchema))
    size = fields.Integer()
