import datetime
from dateutil import relativedelta
from dataclasses import dataclass
from crm.agency_cabinet.common.service_discovery import ServiceDiscovery
from crm.agency_cabinet.agencies.common import structs as agencies_structs
from crm.agency_cabinet.grants.common.consts import Permissions
from crm.agency_cabinet.gateway.server.src.procedures.common import check_grants


@dataclass
class GetMarketSituationData:
    __slots__ = 'sd'

    sd: ServiceDiscovery

    @check_grants(permissions_list=(Permissions.analytics.value,), feature_flag_name='ANALYTICS_API_NEW_GRANTS')
    async def __call__(
        self,
        yandex_uid: int,
        agency_id: int,
        left_date: datetime.date,
        right_date: datetime.date
    ) -> agencies_structs.GetMarketSituationResponse:
        return await self.sd.agencies.get_market_situation(
            agency_id,
            left_date,
            left_date + relativedelta.relativedelta(months=1),
            right_date,
            right_date + relativedelta.relativedelta(months=1)
        )


@dataclass
class GetGetActiveClientsData:
    __slots__ = 'sd'

    sd: ServiceDiscovery

    @check_grants(permissions_list=(Permissions.analytics.value,), feature_flag_name='ANALYTICS_API_NEW_GRANTS')
    async def __call__(
        self,
        yandex_uid: int,
        agency_id: int,
        left_date: datetime.date,
        right_date: datetime.date
    ) -> agencies_structs.GetActiveClientsResponse:
        return await self.sd.agencies.get_active_clients(
            agency_id,
            left_date,
            left_date + relativedelta.relativedelta(months=1),
            right_date,
            right_date + relativedelta.relativedelta(months=1)
        )


@dataclass
class GetGradesDistributionData:
    __slots__ = 'sd'

    sd: ServiceDiscovery

    @check_grants(permissions_list=(Permissions.analytics.value,), feature_flag_name='ANALYTICS_API_NEW_GRANTS')
    async def __call__(
        self,
        yandex_uid: int,
        agency_id: int,
        left_date: datetime.date,
        right_date: datetime.date
    ) -> agencies_structs.GetAverageBudgetDistributionResponse:
        return await self.sd.agencies.get_average_budget_distribution(agency_id, left_date, right_date)


@dataclass
class GetGetClientsIncreaseData:
    __slots__ = 'sd'

    sd: ServiceDiscovery

    @check_grants(permissions_list=(Permissions.analytics.value,), feature_flag_name='ANALYTICS_API_NEW_GRANTS')
    async def __call__(
        self,
        yandex_uid: int,
        agency_id: int,
        left_date: datetime.date,
        right_date: datetime.date
    ) -> agencies_structs.GetClientsIncreaseResponse:
        return await self.sd.agencies.get_clients_increase(
            agency_id,
            left_date,
            left_date + relativedelta.relativedelta(months=1),
            right_date,
            right_date + relativedelta.relativedelta(months=1)
        )
