import typing
import inspect
import functools
from environs import Env
from crm.agency_cabinet.gateway.server.src.exceptions import AccessDenied
from crm.agency_cabinet.grants.common.structs import AccessLevel, CheckPermissionsResponse
from crm.agency_cabinet.grants.common.consts.partner import PartnerType

# TODO: temp, delete
env = Env()


def check_feature(prefix):
    return env.bool(f"USE_{prefix.upper()}", False)


async def _check_grants(yandex_uid, agency_or_partner_id, permissions_list, sd, feature_flag_name,
                        use_agency_id_for_check=True) -> typing.Optional[CheckPermissionsResponse]:
    if check_feature(feature_flag_name) or check_feature('ANY_API_NEW_GRANTS'):  # TODO: remove
        kwargs = {}
        if use_agency_id_for_check:
            kwargs['agency_id'] = agency_or_partner_id
        else:
            kwargs['partner_id'] = agency_or_partner_id
        result = await sd.grants.check_permissions(
            yandex_uid=yandex_uid,
            permissions=permissions_list,
            **kwargs
        )
        if not result.is_have_permissions:
            raise AccessDenied()
        return result
    else:
        # TODO: remove
        access_level = await sd.grants.check_access_level(
            yandex_uid=yandex_uid, agency_id=agency_or_partner_id
        )

        if access_level == AccessLevel.DENY:
            raise AccessDenied()


def check_grants(
    permissions_list: typing.Union[typing.List[str], typing.Tuple[str, ...]] = (),
    feature_flag_name: str = 'ANY_API_NEW_GRANTS',
    force_original_parameter=False
):
    # TODO: тут сейчас непонятный хаос - сделать лучше после переезда на новую схему со стороны фронта
    def wrapper(func):
        args_name = [name for name in inspect.signature(func).parameters.keys()]
        assert len(args_name) > 2
        assert args_name[0] == 'self'
        assert args_name[1] == 'yandex_uid'
        assert args_name[2] == 'agency_id' or args_name[2] == 'partner_id'
        expected_partner_id = args_name[2] == 'partner_id'
        if not expected_partner_id:
            @functools.wraps(func)
            async def decorator(self, yandex_uid, agency_id, *args, **kwargs):
                # TODO: tmp
                accept_agency_id_param_as_partner_id = check_feature('AGENCY_ID_AS_PARTNER_ID')
                if accept_agency_id_param_as_partner_id:
                    use_agency_id_for_check = False
                else:
                    use_agency_id_for_check = True

                check = await _check_grants(yandex_uid, agency_id, permissions_list, self.sd, feature_flag_name,
                                            use_agency_id_for_check=use_agency_id_for_check)

                if accept_agency_id_param_as_partner_id and not force_original_parameter:
                    if check.partner.type != PartnerType.agency:
                        raise AccessDenied()
                    real_agency_id = int(check.partner.external_id)
                    return await func(self, yandex_uid, real_agency_id, *args, **kwargs)
                    # Прокидываем agency_id в процедуру, которая его ждет, считая что на входе нам был дан partner_id
                    # (под именем agency_id)
                else:
                    # Прокидываем partner_id (либо agency_id пока мы продолжаем использовать его)
                    # в процедуру, которая ждем agency_id (для ord) -
                    # таким образом в ord в agency_id будет хранится partner_id
                    # потом надо переименовать;
                    # данные созданные в ord до переключения придется почистить
                    return await func(self, yandex_uid, agency_id, *args, **kwargs)
            return decorator
        else:
            @functools.wraps(func)
            async def decorator(self, yandex_uid, partner_id, *args, **kwargs):
                await _check_grants(yandex_uid, partner_id, permissions_list, self.sd, feature_flag_name,
                                    use_agency_id_for_check=False)
                return await func(self, yandex_uid, partner_id, *args, **kwargs)

            return decorator
    return wrapper


async def _check_oauth_permissions(oauth_token, partner_id, permissions_list, real_ip, sd) -> typing.Optional[CheckPermissionsResponse]:
    result = await sd.grants.check_oauth_permissions(
        oauth_token=oauth_token,
        partner_id=partner_id,
        permissions=permissions_list,
        real_ip=real_ip,
    )
    if not result.is_have_permissions:
        raise AccessDenied()
    return result


def check_oauth_permissions(permissions_list: typing.Union[typing.List[str], typing.Tuple[str, ...]] = ()):
    def wrapper(func):
        args_name = [name for name in inspect.signature(func).parameters.keys()]
        assert len(args_name) > 2
        assert args_name[0] == 'self'
        assert args_name[1] == 'partner_id'
        assert args_name[2] == 'oauth_token'
        assert args_name[3] == 'real_ip'

        @functools.wraps(func)
        async def decorator(self, oauth_token, partner_id, real_ip, *args, **kwargs):
            await _check_oauth_permissions(oauth_token, partner_id, real_ip, permissions_list, self.sd)
            return await func(self, partner_id, oauth_token, *args, **kwargs)
        return decorator
    return wrapper


def tmp_decorator_to_switch_partner_id(func):
    args_name = [name for name in inspect.signature(func).parameters.keys()]
    assert len(args_name) > 2
    assert args_name[0] == 'self'
    assert args_name[1] == 'yandex_uid'
    assert args_name[2] == 'agency_id'
    args_names = set(args_name)

    @functools.wraps(func)
    async def decorator(self, yandex_uid, agency_id, *args, **kwargs):
        accept_agency_id_param_as_partner_id = check_feature('AGENCY_ID_AS_PARTNER_ID')
        if accept_agency_id_param_as_partner_id and 'partner_id' in args_names:
            return await func(self, yandex_uid, None, *args, partner_id=agency_id, **kwargs)
        else:
            return await func(self, yandex_uid, agency_id, *args, **kwargs)
    return decorator
