from dataclasses import dataclass
from datetime import datetime

from crm.agency_cabinet.documents.common.structs import (
    Payment,
)
from crm.agency_cabinet.common.service_discovery import ServiceDiscovery
from crm.agency_cabinet.gateway.server.src.procedures.common import check_grants
from crm.agency_cabinet.grants.common.consts import Permissions


__all__ = ["ListPayments"]


@dataclass
class ListPayments:
    __slots__ = "sd"

    sd: ServiceDiscovery

    @check_grants(permissions_list=(Permissions.documents.value,))
    async def __call__(
        self,
        yandex_uid: int,
        agency_id: int,
        limit: int = None,
        offset: int = None,
        contract_id: int = None,
        invoice_id: int = None,
        date_from: datetime = None,
        date_to: datetime = None,
    ) -> list[Payment]:
        return await self.sd.documents.list_payments(
            agency_id=agency_id,
            limit=limit,
            contract_id=contract_id,
            invoice_id=invoice_id,
            offset=offset,
            date_from=date_from,
            date_to=date_to,
        )
