import asyncio
from dataclasses import dataclass

from crm.agency_cabinet.common.service_discovery import ServiceDiscovery


@dataclass
class HealthCheck:
    __slots__ = 'sd'

    sd: ServiceDiscovery

    async def __call__(self) -> bool:
        tasks = [
            asyncio.create_task(self.sd.grants.ping())
        ]
        await asyncio.gather(*tasks)
        return True
