from dataclasses import dataclass

from crm.agency_cabinet.common.service_discovery import ServiceDiscovery
from crm.agency_cabinet.ord.common.structs import CampaignList
from crm.agency_cabinet.grants.common.consts import Permissions
from crm.agency_cabinet.gateway.server.src.procedures.common import check_grants


@dataclass
class ListCampaigns:
    __slots__ = 'sd'

    sd: ServiceDiscovery

    @check_grants(permissions_list=(Permissions.ord.value,), force_original_parameter=True)
    async def __call__(
        self,
        yandex_uid: int,
        agency_id: int,
        report_id: int,
        client_id: int,
        limit: int = None,
        offset: int = None,
        search_query: str = None
    ) -> CampaignList:
        return await self.sd.ord.get_campaigns(
            agency_id=agency_id,
            report_id=report_id,
            client_id=client_id,
            limit=limit,
            offset=offset,
            search_query=search_query
        )
