from dataclasses import dataclass

from crm.agency_cabinet.common.service_discovery import ServiceDiscovery
from crm.agency_cabinet.ord.common import structs
from crm.agency_cabinet.grants.common.consts import Permissions
from crm.agency_cabinet.gateway.server.src.procedures.common import check_grants


@dataclass
class GetInvites:
    __slots__ = 'sd'

    sd: ServiceDiscovery

    @check_grants(permissions_list=(Permissions.ord.value,), force_original_parameter=True)
    async def __call__(self,
                       yandex_uid: int,
                       agency_id: int,
                       limit: int = None,
                       offset: int = None,
                       ) -> structs.InviteList:
        return await self.sd.ord.get_invites(
            agency_id=agency_id,
            limit=limit,
            offset=offset,
        )
