from dataclasses import dataclass

from crm.agency_cabinet.common.service_discovery import ServiceDiscovery
from crm.agency_cabinet.ord.common.structs import OrganizationsList
from crm.agency_cabinet.grants.common.consts import Permissions
from crm.agency_cabinet.gateway.server.src.procedures.common import check_grants


@dataclass
class ListOrganizations:
    __slots__ = 'sd'

    sd: ServiceDiscovery

    @check_grants(permissions_list=(Permissions.ord.value,), force_original_parameter=True)
    async def __call__(
        self,
        yandex_uid: int,
        partner_id: int,
        limit: int = None,
        offset: int = None,
        search_query: str = None
    ) -> OrganizationsList:
        return await self.sd.ord.get_organizations(
            partner_id=partner_id,
            limit=limit,
            offset=offset,
            search_query=search_query
        )
