PY3TEST()

OWNER(
    g:agency_cabinet_back
)

SIZE(MEDIUM)

PEERDIR(
    contrib/python/pytest-asyncio
    contrib/python/pytest-mock
    crm/agency_cabinet/gateway/server
    crm/agency_cabinet/common/testing
    crm/agency_cabinet/common/server/common/structs
    smb/common/testing_utils
)

PY_SRCS(
    conftest.py
    middlewares/conftest.py
    procedures/certificates/conftest.py
)

TEST_SRCS(
    handlers/ord/acts/test_add_act.py
    handlers/ord/acts/test_edit_act.py
    handlers/ord/client_rows/test_edit_client_row.py
    handlers/ord/client_rows/test_get_client_rows.py
    handlers/ord/clients/test_create_client.py
    handlers/ord/clients/test_clients_info.py
    handlers/ord/clients/test_get_client_short_info.py
    handlers/ord/invites/test_get_invites.py
    handlers/ord/organizations/test_list_organizations.py
    handlers/ord/reports/test_get_lock_status.py
    handlers/ord/reports/test_reports_info.py
    handlers/ord/reports/test_send_report.py
    handlers/ord/reports/test_get_report_url.py
    handlers/ord/reports/test_report_export.py
    handlers/ord/reports/test_import_report.py
    handlers/ord/reports/test_delete_report.py
    handlers/ord/reports/test_create_report.py
    handlers/ord/reports/test_list_campaigns.py
    handlers/ord/contracts/test_list_contracts.py

    handlers/agencies/test_agency_info.py
    handlers/agencies/test_list_agencies.py
    handlers/agencies/test_list_clients.py
    handlers/agencies/test_list_conracts.py
    handlers/analytics/test_get_grades_distribution.py
    handlers/analytics/test_get_market_situation.py
    handlers/analytics/test_get_active_clients.py
    handlers/analytics/test_get_clients_increase.py
    handlers/certificates/test_fetch_agency_certificates_history.py
    handlers/certificates/test_list_agency_certificates.py
    handlers/certificates/test_list_employees_certificates.py
    handlers/certificates/test_get_agency_certificate_details.py
    handlers/bonuses/test_list_bonuses.py
    handlers/bonuses/test_fetch_client_bonuses_log.py
    handlers/bonuses/test_fetch_client_graph.py
    handlers/bonuses/test_fetch_client_bonuses.py
    handlers/bonuses/test_get_bonuses_settings.py
    handlers/bonuses/test_get_report_info.py
    handlers/bonuses/test_get_report_url.py
    handlers/bonuses/test_create_bonuses_reports.py
    handlers/bonuses/test_delete_bonuses_reports.py
    handlers/bonuses/test_list_cashback_programs.py
    handlers/bonuses/test_list_bonuses_reports.py

    handlers/roles/test_list_users.py
    handlers/roles/test_edit_user.py
    handlers/roles/test_list_suggest_users.py
    handlers/roles/test_list_roles.py
    handlers/roles/test_list_user_roles.py
    handlers/roles/test_list_partners.py

    handlers/rewards/documents/test_download_url.py
    handlers/rewards/calculator/test_list_available_calculators.py
    handlers/rewards/calculator/test_get_init_data.py
    handlers/rewards/calculator/test_get_meta.py
    handlers/rewards/reports/test_reports_info.py
    handlers/rewards/reports/test_download_url.py
    handlers/rewards/test_rewards_info.py
    handlers/rewards/test_dashboard.py

    handlers/documents/test_list_contracts.py
    handlers/documents/test_get_contract_info.py
    handlers/documents/test_list_invoices.py
    handlers/documents/test_list_payments.py
    handlers/documents/test_list_acts.py
    handlers/documents/test_get_invoice_info.py
    handlers/documents/test_get_invoice_url.py
    handlers/documents/test_get_act_url.py
    handlers/documents/test_get_agreement_url.py
    handlers/documents/test_get_contract_url.py

    handlers/infra/test_docs.py

    procedures/bonuses/test_fetch_client_bonuses_log.py
    procedures/bonuses/test_list_clients_bonuses.py
    procedures/bonuses/test_fetch_client_graph.py
    procedures/bonuses/test_get_clients_bonuses_settings.py
    procedures/bonuses/test_list_bonuses_reports.py
    procedures/bonuses/test_create_bonuses_reports.py
    procedures/bonuses/test_delete_bonuses_reports.py
    procedures/bonuses/test_list_cashback_programs.py

    procedures/certificates/test_fetch_agency_certificates_history.py
    procedures/certificates/test_list_employees_certificates.py
    procedures/certificates/test_list_agency_certificates.py
    procedures/certificates/test_get_agency_certificate_details.py
    procedures/documents/test_list_contracts.py
    procedures/documents/test_list_invoices.py
    procedures/documents/test_get_contract_info.py
    procedures/documents/test_list_payments.py
    procedures/documents/test_list_acts.py
    procedures/documents/test_get_invoice_info.py
    procedures/documents/test_get_invoice_url.py
    procedures/documents/test_get_act_url.py

    procedures/ord/test_export_report.py
    procedures/ord/test_get_campaigns.py

    procedures/rewards/calculator/test_list_available_calculators.py

    procedures/roles/test_list_user_roles.py
    procedures/roles/test_list_partners.py

    middlewares/test_error_middleware.py
)

IF(NOT OS_DARWIN)
    FORK_TEST_FILES()
ENDIF()

END()
