PY3_LIBRARY()

OWNER(
    g:agency_cabinet_back
)


PEERDIR(
    contrib/python/environ-config
    contrib/python/marshmallow/py3
    contrib/python/marshmallow-enum/py3
    contrib/python/dateutil

    crm/agency_cabinet/client_bonuses/server
    crm/agency_cabinet/common/consts
    crm/agency_cabinet/common/db
    crm/agency_cabinet/common/mds
    crm/agency_cabinet/common/server/web
    crm/agency_cabinet/common/service_discovery
    crm/agency_cabinet/common/aiohttp_logging
    crm/agency_cabinet/common/monitoring
    crm/agency_cabinet/common/utils
    crm/agency_cabinet/documents/common
    crm/agency_cabinet/grants/common
)


PY_SRCS(
    src/handlers/schemas/__init__.py
    src/handlers/schemas/agencies.py
    src/handlers/schemas/certificates.py
    src/handlers/schemas/common.py
    src/handlers/schemas/analytics.py
    src/handlers/schemas/bonuses.py
    src/handlers/schemas/dashboard.py
    src/handlers/schemas/roles.py

    src/handlers/schemas/ord/__init__.py
    src/handlers/schemas/ord/acts.py
    src/handlers/schemas/ord/campaigns.py
    src/handlers/schemas/ord/client_rows.py
    src/handlers/schemas/ord/clients.py
    src/handlers/schemas/ord/contracts.py
    src/handlers/schemas/ord/organizations.py
    src/handlers/schemas/ord/reports.py
    src/handlers/schemas/ord/invites.py

    src/handlers/schemas/documents/__init__.py
    src/handlers/schemas/documents/contracts.py
    src/handlers/schemas/documents/invoices.py
    src/handlers/schemas/documents/payments.py
    src/handlers/schemas/documents/acts.py
    src/handlers/schemas/documents/common.py
    src/handlers/schemas/documents/agreements.py

    src/handlers/schemas/rewards/reports.py
    src/handlers/schemas/rewards/rewards.py
    src/handlers/schemas/rewards/documents.py
    src/handlers/schemas/rewards/calculator.py

    src/handlers/__init__.py
    src/handlers/agencies.py
    src/handlers/analytics.py
    src/handlers/certificates.py
    src/handlers/common.py
    src/handlers/infra.py
    src/handlers/bonuses.py
    src/handlers/roles.py

    src/handlers/ord/__init__.py
    src/handlers/ord/acts.py
    src/handlers/ord/campaigns.py
    src/handlers/ord/client_rows.py
    src/handlers/ord/clients.py
    src/handlers/ord/organizations.py
    src/handlers/ord/reports.py
    src/handlers/ord/contracts.py
    src/handlers/ord/invites.py

    src/handlers/documents/acts.py
    src/handlers/documents/contracts.py
    src/handlers/documents/payments.py
    src/handlers/documents/__init__.py
    src/handlers/documents/invoices.py
    src/handlers/documents/agreements.py

    src/handlers/rewards/__init__.py
    src/handlers/rewards/calculator.py
    src/handlers/rewards/reports.py
    src/handlers/rewards/rewards.py
    src/handlers/rewards/documents.py

    src/procedures/__init__.py
    src/procedures/agencies.py
    src/procedures/certificates.py
    src/procedures/infra.py
    src/procedures/bonuses.py
    src/procedures/roles.py
    src/procedures/analytics.py

    src/procedures/ord/__init__.py
    src/procedures/ord/acts.py
    src/procedures/ord/campaigns.py
    src/procedures/ord/client_rows.py
    src/procedures/ord/clients.py
    src/procedures/ord/import_data.py
    src/procedures/ord/organizations.py
    src/procedures/ord/reports.py
    src/procedures/ord/contracts.py
    src/procedures/ord/invites.py

    src/procedures/documents/acts.py
    src/procedures/documents/contracts.py
    src/procedures/documents/invoices.py
    src/procedures/documents/payments.py
    src/procedures/documents/__init__.py
    src/procedures/documents/agreements.py

    src/procedures/rewards/reports.py
    src/procedures/rewards/documents.py
    src/procedures/rewards/rewards.py
    src/procedures/rewards/calculator.py

    src/procedures/common.py

    src/__init__.py
    src/config.py
    src/exceptions.py
    src/structs.py
    src/middlewares/__init__.py
    src/middlewares/error.py
    src/middlewares/validation.py
)


END()

RECURSE(bin)

RECURSE_FOR_TESTS(tests)
