import functools
import json
import logging

from aiohttp import web
from aiohttp_apispec import headers_schema

from crm.agency_cabinet.gateway_external.server.src.exceptions import ProcedureException
from crm.agency_cabinet.gateway_external.server.src.schemas import common_schemas
from crm.agency_cabinet.gateway_external.server.src.structs import ErrorDetailsSchema

LOGGER = logging.getLogger('gateway_external.common')


def json_response(*args, **kwargs):
    kwargs['dumps'] = json.JSONEncoder(ensure_ascii=False).encode
    return web.json_response(*args, **kwargs)


def development_headers_docs(f):
    @functools.wraps(f)
    @headers_schema(common_schemas.DevelopmentHeadersSchema)
    def wrapper(*args, **kwargs):
        return f(*args, **kwargs)
    return wrapper


def error_response(e: ProcedureException) -> web.Response:
    if hasattr(e, 'error_details'):
        return web.json_response(
            data={
                'error': ErrorDetailsSchema().dump(
                    e.error_details)},
            status=e.error_details.http_code or 500)
    else:
        return web.json_response(data={'error': e.message}, status=e.http_code or 500)
