from aiohttp import web
from aiohttp_apispec import docs, querystring_schema
from marshmallow import EXCLUDE

from crm.agency_cabinet.common.service_discovery import ServiceDiscovery
from crm.agency_cabinet.gateway_external.server.src.handlers.common import development_headers_docs, json_response
from crm.agency_cabinet.gateway_external.server.src.schemas import ord_reports_schemas
from crm.agency_cabinet.gateway_external.server.src.procedures import ord_reports_procedures


class OrdReportsCollection:
    def __init__(self, sd: ServiceDiscovery):
        self._list_reports = ord_reports_procedures.ListReports(sd)

    @docs(
        tags=['ord external'],
        summary='Список отчётов ОРД',
        responses={
            200: {
                'schema': ord_reports_schemas.OrdReportsListSchema(),
                'description': 'Ok'
            },
            401: {
                'description': 'Unauthorized'
            },
            403: {
                'description': 'Forbidden'
            }
        }
    )
    @querystring_schema(ord_reports_schemas.RequestOrdReportsSchema(unknown=EXCLUDE))
    @development_headers_docs
    async def list_reports(self, request: web.Request) -> web.Response:
        reports = await self._list_reports(
            app_client_id=request['app_client_id'],
            **request['querystring']
        )
        data = {
            'size': len(reports),
            'items': reports
        }
        return json_response(data=ord_reports_schemas.OrdReportsListSchema().dump(data))
