import typing
from dataclasses import dataclass

from crm.agency_cabinet.common.service_discovery import ServiceDiscovery
from crm.agency_cabinet.ord.common.structs import ReportInfo
from crm.agency_cabinet.grants.common.consts import Permissions
from crm.agency_cabinet.gateway_external.server.src.procedures.common import check_oauth_permissions


@dataclass
class ListReports:
    __slots__ = 'sd'

    sd: ServiceDiscovery

    @check_oauth_permissions(permissions_list=(Permissions.ord.value,))
    async def __call__(
        self,
        app_client_id: str,
        partner_id: int = None,
        limit: int = None,
        offset: int = None,
    ) -> typing.List[ReportInfo]:
        return await self.sd.ord.get_reports_info(
            agency_id=partner_id,
            limit=limit,
            offset=offset
        )
