from marshmallow import Schema, fields, validate


class DevelopmentHeadersSchema(Schema):
    no_check_service_ticket = fields.String(data_key='No-Check-Service-Ticket',
                                            metadata={'description': 'Можно передать любое значение. '
                                                                     'Работает только в developer_mode.'})
    no_check_oauth = fields.String(data_key='No-Check-OAuth',
                                   metadata={'description': 'Нужно передавать сразу app_client_id вместо токена. '
                                                            'Работает только в developer_mode.'})
    authorization = fields.String(data_key='Authorization OAuth', metadata={'description': 'Авторизационный токен'})
    real_api = fields.String(data_key='X-Forwarded-For-Y',
                             metadata={'description': 'IP-адрес пользователя. Указывается в стандартном формате IPv4 '
                                                      '(например, 194.84.46.241)'})


class LimitOffsetSchema(Schema):
    limit = fields.Integer(validate=validate.Range(min=0))
    offset = fields.Integer(validate=validate.Range(min=0))


class SearchQuerySchema(Schema):
    search_query = fields.String(validate=validate.Length(min=1))


class SizedSchema(Schema):
    size = fields.Integer()
