from marshmallow import fields, Schema

from crm.agency_cabinet.gateway_external.server.src.schemas.common import LimitOffsetSchema, SizedSchema


__all__ = [
    'RequestOrdReportsSchema',
    'OrdReportsListSchema',
    'OrdReportSchema',
]


class RequestOrdReportsSchema(LimitOffsetSchema):
    pass


class ReportSettingsSchema(Schema):
    name = fields.String(required=True)


class OrdReportSchema(Schema):
    report_id = fields.Integer(required=True)
    type = fields.Pluck(ReportSettingsSchema, 'name', attribute='settings')
    sending_date = fields.Date()
    reporter_type = fields.String(required=True)
    status = fields.String(required=True)
    period_from = fields.Date(required=True)


class OrdReportsListSchema(SizedSchema):
    items = fields.List(fields.Nested(OrdReportSchema))
