PY3_LIBRARY()

OWNER(
    g:agency_cabinet_back
)


PEERDIR(
    contrib/python/environ-config
    contrib/python/marshmallow/py3
    contrib/python/marshmallow-enum/py3
    contrib/python/dateutil
    crm/agency_cabinet/common/consts
    crm/agency_cabinet/common/db
    crm/agency_cabinet/common/mds
    crm/agency_cabinet/common/server/web
    crm/agency_cabinet/common/service_discovery
    crm/agency_cabinet/client_bonuses/server
    crm/agency_cabinet/common/aiohttp_logging
    crm/agency_cabinet/common/blackbox
    crm/agency_cabinet/common/monitoring
    crm/agency_cabinet/documents/common
    crm/agency_cabinet/common/utils
)


PY_SRCS(
    src/schemas/__init__.py
    src/schemas/common.py
    src/schemas/ord/reports.py

    src/handlers/__init__.py
    src/handlers/infra.py
    src/handlers/common.py
    src/handlers/ord/reports.py


    src/procedures/__init__.py
    src/procedures/infra.py
    src/procedures/common.py
    src/procedures/ord/reports.py

    src/__init__.py
    src/config.py
    src/exceptions.py
    src/structs.py

    src/middlewares/__init__.py
    src/middlewares/error.py
    src/middlewares/validation.py
)


END()

RECURSE(bin)

RECURSE_FOR_TESTS(tests)
