import json
import logging
import typing

from aiohttp import web

LOGGER = logging.getLogger('gateway_internal.common')


def json_response(*args, **kwargs):
    kwargs['dumps'] = json.JSONEncoder(ensure_ascii=False).encode
    return web.json_response(*args, **kwargs)


def get_real_ip(request: web.Request) -> typing.Optional[str]:
    if 'X-Forwarded-For-Y' in request.headers:
        return request.headers['X-Forwarded-For-Y']

    if 'X-Real-IP' in request.headers:
        return request.headers['X-Real-IP']

    real_ip = request.headers.get('REMOTE_ADDR', None)
    if real_ip is None:
        LOGGER.warning('Unable to determine real IP address, received headers: %s', request.headers.keys())

    return real_ip
